package gov.va.med.mhv.usermgmt.service;

import gov.va.med.mhv.usermgmt.enumeration.AuthenticationStatus;
import gov.va.med.mhv.usermgmt.enumeration.ContactMethodEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.CountryEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.GenderEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.OrganizationTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.PasswordHintQuestionEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.PatientCorrelationStatus;
import gov.va.med.mhv.usermgmt.enumeration.StateEnumeration;
import gov.va.med.mhv.usermgmt.service.delegate.EntityMaintenanceServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.transfer.Employee;
import gov.va.med.mhv.usermgmt.transfer.EmployeeOrganizationRole;
import gov.va.med.mhv.usermgmt.transfer.Facility;
import gov.va.med.mhv.usermgmt.transfer.FacilityInfo;
import gov.va.med.mhv.usermgmt.transfer.InPersonAuthentication;
import gov.va.med.mhv.usermgmt.transfer.Organization;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.Role;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;
import gov.va.med.mhv.usermgmt.util.PatientCorrelationStatusUtils;

import java.sql.Timestamp;
import java.util.Date;

public class ConcreteFactory {
	public static FacilityInfoServiceResponse createFacilityInfo(String name, String stationNumber) {
		FacilityInfo fi = TransferObjectFactory.createFacilityInfo();
		
		fi.setName(name);
		fi.setStationNumber(stationNumber);
		fi.setActive(Boolean.TRUE);
		fi.setTreatment(Boolean.TRUE);
		fi.setDomainName("somewhere.domain");
		fi.setIpAddess("42.42.42.42");
		fi.setPort(new Integer(42));
		fi.setTimeout(new Long(0));
		
		EntityMaintenanceServiceDelegate umDelegate = 
			ServiceDelegateFactory.createEntityMaintenanceServiceDelegate();

		return(umDelegate.save(fi));
	}
	
	public static OrganizationServiceResponse createOrganization(FacilityInfo facility) {
		Organization org = TransferObjectFactory.createOrganization();
		
		org.setFacilityInfo(facility);
		org.setName(facility.getName());
		org.setTypeOfOrganization(OrganizationTypeEnumeration.getEnum(OrganizationTypeEnumeration.FACILITY));
		
		EntityMaintenanceServiceDelegate umDelegate = 
			ServiceDelegateFactory.createEntityMaintenanceServiceDelegate();

		return(umDelegate.save(org));
	}

	public static PatientServiceResponse createPatient(String icn, UserProfile userProfile, FacilityInfo... txFacilities) {
		Patient patient = TransferObjectFactory.createPatient();
		patient.setIcn(icn);
        
        patient.setCorrelationStatus(PatientCorrelationStatusUtils.UNCORRELATED);
		
		//associate user profile
		patient.setUserProfile(userProfile);
		
		//create treatment facility
		for (FacilityInfo facilityInfo : txFacilities) {
			Facility f = TransferObjectFactory.createFacility();
			f.setName(facilityInfo.getStationNumber());
			f.setFacilityInfo(facilityInfo);
			patient.addFacility(f);
		}
		
		//TODO: Consider using sanctioned service instead of EntityMaintenance 
		EntityMaintenanceServiceDelegate umDelegate = 
			ServiceDelegateFactory.createEntityMaintenanceServiceDelegate();
		
		return(umDelegate.save(patient));
	}
	
	public static UserProfileServiceResponse createUserProfile(String firstName, String lastName, String userName, String ssn, Date dateOfBirth, GenderEnumeration gender, Boolean isPatient, Boolean isVeteran) {
		UserProfile userProfile = TransferObjectFactory.createUserProfile();

		//set required demographic fields
		userProfile.setFirstName(firstName);
		userProfile.setLastName(lastName);
		userProfile.setBirthDate(dateOfBirth);
		userProfile.setGender(gender);
		userProfile.setSsn(ssn);

		//set required identity flags
		//userProfile.setIsActive(Boolean.TRUE);
	
		userProfile.setIsPatient(isPatient);
		userProfile.setIsVeteran(isVeteran);

		//set required acceptance fields
		userProfile.setAcceptDisclaimer(Boolean.TRUE);
		userProfile.setAcceptPrivacy(Boolean.TRUE);
		userProfile.setAcceptTerms(Boolean.TRUE);
		
		//set required login info
		userProfile.setUserName(userName);
		userProfile.setPasswordHintQuestion1(PasswordHintQuestionEnumeration.getEnum(PasswordHintQuestionEnumeration.PETNAME));
		userProfile.setPasswordHintQuestion2(PasswordHintQuestionEnumeration.getEnum(PasswordHintQuestionEnumeration.FAVORITEFOOD));
		userProfile.setPasswordHintAnswer1("Santa's Little Helper");
		userProfile.setPasswordHintAnswer2("Donuts");

		//set required contact info
		userProfile.setAddressStreet1("742 Evergreen Terrace");
		userProfile.setAddressCity("Springfield");
		userProfile.setAddressState(StateEnumeration.getEnum(StateEnumeration.CA));
		userProfile.setAddressPostalCode("90211");
		userProfile.setAddressCountry(CountryEnumeration.getEnum(CountryEnumeration.UNITED_STATES));
		userProfile.setContactInfoContactMethod(ContactMethodEnumeration.getEnum(ContactMethodEnumeration.HOMEPHONE));
		userProfile.setContactInfoHomePhone("555-555-8707");

		EntityMaintenanceServiceDelegate delegate = 
			ServiceDelegateFactory.createEntityMaintenanceServiceDelegate();
		
		return(delegate.save(userProfile));
	}

	public static InPersonAuthenticationServiceResponse createIPA(Patient patient, FacilityInfo authenticatingFacility, AuthenticationStatus status) {
		InPersonAuthentication ipa = TransferObjectFactory.createInPersonAuthentication();
		ipa.setPatient(patient);
		ipa.setAuthenticatingFacility(authenticatingFacility);
		ipa.setIdentificationPresented(Boolean.TRUE);
		ipa.setParticipationFormSigned(Boolean.TRUE);
		ipa.setVideoViewed(Boolean.TRUE);
		ipa.setApprovedForRecordsAccess(Boolean.TRUE);
		ipa.setStatus(status);
		if (status.equals(AuthenticationStatus.getEnum(AuthenticationStatus.AUTHENTICATED)))
			ipa.setAuthenticationDate(new Timestamp(System.currentTimeMillis()));

		EntityMaintenanceServiceDelegate delegate =	ServiceDelegateFactory.createEntityMaintenanceServiceDelegate();
		return(delegate.save(ipa));
	}
	
	public static EmployeeServiceResponse createEmployee(String firstName, String lastName, String userName) {
		Employee employee = TransferObjectFactory.createEmployee();
		employee.setFirstName(firstName);
		employee.setLastName(lastName);
		employee.setUserName(userName);
	
		//TODO: Consider using sanctioned service instead of EntityMaintenance 
		EntityMaintenanceServiceDelegate umDelegate = 
			ServiceDelegateFactory.createEntityMaintenanceServiceDelegate();
	
		return(umDelegate.save(employee));
	}

	public static EmployeeOrganizationRoleServiceResponse assignRole(Employee employee, Organization facilityOrg, Role role) {
		EntityMaintenanceServiceDelegate umDelegate = 
			ServiceDelegateFactory.createEntityMaintenanceServiceDelegate();

/*		TODO: Consider using sanctioned service instead of EntityMaintenance.  Specificially, use 
 * 				assignEmployeeOrganizationRole(), but first know that this requires 
 * 				setting up a hierarchy of employees and related objects with all the right priveledges (to create 
 * 				ROI admin you must be a Facility Admin, to create Facility Admin you must be VISN admin, to create 
 * 				VISN admin you must be a National Admin. */
//		EmployeeRoleManagementServiceDelegate delegate = ServiceDelegateFactory.createEmployeeRoleManagementServiceDelegate();
//		EmployeeOrganizationRoleServiceResponse response = 
//			delegate.assignEmployeeOrganizationRole(facilityAdmin, employee.getUserName(), Long.toString(facility.getId().longValue()), Long.toString(roleId));
		
		EmployeeOrganizationRole orgRole = TransferObjectFactory.createEmployeeOrganizationRole();
		orgRole.setActive(Boolean.TRUE);
		orgRole.setEmployee(employee);
		orgRole.setRole(role);
		orgRole.setOrganization(facilityOrg);
		
		return(umDelegate.save(orgRole));
	}
}
